"""Define the menu contents, hotkeys, and event bindings.

There is additional configuration information in the EditorWindow class (and
subclasses): the menus are created there based on the menu_specs (class)
variable, and menus not created are silently skipped in the code here.  This
makes it possible, for example, to define a Debug menu which is only present in
the PythonShell window, and a Format menu which is only present in the Editor
windows.

"""
import sys
from configHandler import idleConf

menudefs = [
 # underscore prefixes character to underscore
 ('file', [
   ('새 문서(_N)', '<<open-new-window>>'),
   ('열기(_O)', '<<open-window-from-file>>'),
   ('모듈 열기(_M)', '<<open-module>>'),
   ('클래스 탐색기(_B)', '<<open-class-browser>>'),
   ('경로 탐색기(_P)', '<<open-path-browser>>'),
   None,
   ('저장(_S)', '<<save-window>>'),
   ('새 이름으로(_A)', '<<save-window-as-file>>'),
   ('새 이름으로 복사(_P)', '<<save-copy-of-window-as-file>>'),
   None,
   ('화면 인쇄(_P)', '<<print-window>>'),
   None,
   ('닫기(_C)', '<<close-window>>'),
   ('종료(_x)', '<<close-all-windows>>'),
  ]),
 ('edit', [
   ('실행 취소(_U)', '<<undo>>'),
   ('다시 실행(_R)', '<<redo>>'),
   None,
   ('잘라내기(_T)', '<<cut>>'),
   ('복사(_C)', '<<copy>>'),
   ('붙여넣기(_P)', '<<paste>>'),
   ('전체 선택(_A)', '<<select-all>>'),
   None,
   ('찾기(_F)', '<<find>>'),
   ('다음 찾기(_G)', '<<find-again>>'),
   ('선택 부분 찾기(_S)', '<<find-selection>>'),
   ('여러 파일 찾기', '<<find-in-files>>'),
   ('바꾸기(_E)', '<<replace>>'),
   ('줄 찾아 가기(_L)', '<<goto-line>>'),
  ]),
('format', [
   ('들여쓰기(_I)', '<<indent-region>>'),
   ('내어쓰기(_D)', '<<dedent-region>>'),
   ('주석 삽입(_O)', '<<comment-region>>'),
   ('주석 제거(_N)', '<<uncomment-region>>'),
   ('탭을 공백으로', '<<tabify-region>>'),
   ('공백을 탭으로', '<<untabify-region>>'),
   ('토글 탭 설정', '<<toggle-tabs>>'),
   ('들여쓰기 간격 설정', '<<change-indentwidth>>'),
   ]),
 ('run', [
   ('파이썬 실행', '<<open-python-shell>>'),
   ]),
 ('shell', [
   ('마지막 시작점으로 커서이동(_V)', '<<view-restart>>'),
   ('쉘 재시작(_R)', '<<restart-shell>>'),
   ]),
 ('debug', [
   ('파일/줄 찾아 가기(_G)', '<<goto-file-line>>'),
   ('디버거(!_D)', '<<toggle-debugger>>'),
   ('스택 뷰어(_S)', '<<open-stack-viewer>>'),
   ('자동으로 스택 뷰어 열기(!_A)', '<<toggle-jit-stack-viewer>>'),
   ]),
 ('options', [
   ('IDLE 환경설정(_C)', '<<open-config-dialog>>'),
   ]),
 ('help', [
   ('IDLE 정보(_A)', '<<about-idle>>'),
   None,
   ('IDLE 도움말(_I)', '<<help>>'),
   ('파이썬 문서(_D)', '<<python-docs>>'),
   ]),
]

default_keydefs = idleConf.GetCurrentKeySet()

del sys
